<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Investigation Portal Login</title>
<style>
  * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Georgia', 'Times New Roman', serif; }
  body { height: 100vh; display: flex; justify-content: center; align-items: center; background-color: #f8f9fa; }

  .login-container {
    background-color: #ffffff;
    padding: 30px 25px;
    width: 90%;
    max-width: 400px;
    border-radius: 8px;
    box-shadow: 0px 4px 15px rgba(0,0,0,0.2);
    text-align: center;
  }

  .login-container h1 { margin-bottom: 15px; font-size: 1.8rem; color: #212529; }
  .login-container p { margin-bottom: 20px; font-size: 0.95rem; color: #495057; }

  .login-container input[type="text"], .login-container input[type="password"] {
    width: 100%; padding: 12px 15px; margin-bottom: 15px;
    border: 1px solid #ced4da; border-radius: 5px; font-size: 1rem;
  }
  .login-container input:focus {
    border-color: #007bff; outline: none; box-shadow: 0 0 5px rgba(0,123,255,0.5);
  }

  .login-container button.login-btn {
    width: 100%; padding: 12px; background-color: #007bff; border: none; color: #fff;
    font-size: 1rem; border-radius: 5px; cursor: pointer; transition: 0.3s; margin-bottom: 15px;
  }
  .login-container button.login-btn:hover { background-color: #0056b3; }

  .login-container .social-btn {
    display: flex; align-items: center; justify-content: center;
    width: 100%; padding: 12px; border-radius: 5px; cursor: pointer;
    font-size: 1rem; margin-bottom: 10px; transition: 0.3s; border: 1px solid #ced4da; text-decoration: none;
  }

  .login-container .gmail-btn { background-color: #fff; color: #555; }
  .login-container .gmail-btn img { width: 20px; height: 20px; margin-right: 10px; }
  .login-container .gmail-btn:hover { background-color: #f1f1f1; }

  .login-container .whatsapp-btn { background-color: #25d366; color: #fff; }
  .login-container .whatsapp-btn img { width: 20px; height: 20px; margin-right: 10px; }
  .login-container .whatsapp-btn:hover { background-color: #1ebe5d; }

  @media (max-width: 480px) {
    .login-container { padding: 25px 20px; }
    .login-container h1 { font-size: 1.5rem; }
  }
</style>
</head>
<body>

<div class="login-container">
  <h1>Welcome ACW Investigation Portal</h1>
  <p>Please enter your credentials or login via Gmail / WhatsApp.</p>

  <a href="gmail-login.php" class="social-btn gmail-btn" onclick="alert('Redirect to Google OAuth login');">
    <img src="https://www.gstatic.com/firebasejs/ui/2.0.0/images/auth/google.svg" alt="Google Logo">
    Login with Gmail
  </a>


</div>

</body>
</html>
