<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Sistem Sedang Gangguan</title>

  <!-- AOS Animation -->
  <link rel="stylesheet" href="https://unpkg.com/aos@2.3.1/dist/aos.css"/>

  <style>
    /* Reset & body */
    * { box-sizing: border-box; margin: 0; padding: 0; }
    body {
      background: #f2f6fa;
      font-family: "Inter", Arial, sans-serif;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      padding: 15px;
    }

    /* Card */
    .card {
      width: 100%;
      max-width: 400px;
      background: #ffffff;
      border-radius: 18px;
      padding: 25px;
      box-shadow: 0 10px 35px rgba(0,0,0,0.08);
      border: 1px solid #e4e9f2;
      text-align: center;
      animation: fadeIn 0.8s ease-out;
    }

    /* Title */
    .title {
      background: linear-gradient(135deg, #0077ff, #005dc7);
      padding: 16px;
      border-radius: 14px;
      color: white;
      font-size: 18px;
      font-weight: 700;
      margin-bottom: 20px;
      box-shadow: 0 4px 12px rgba(0,100,255,0.25);
    }

    /* Paragraph */
    p {
      font-size: 14px;
      color: #4a4a4a;
      line-height: 1.6;
      margin-bottom: 20px;
    }

    /* Button modern */
    .btn-modern {
      display: block;
      width: 100%;
      background: #0077ff;
      color: white;
      padding: 14px 0;
      border-radius: 12px;
      font-size: 15px;
      font-weight: 600;
      text-decoration: none;
      transition: 0.25s ease;
      box-shadow: 0 4px 12px rgba(0,118,255,0.25);
    }

    .btn-modern:hover {
      background: #0059c4;
      transform: translateY(-3px);
      box-shadow: 0 8px 16px rgba(0,118,255,0.35);
    }

    /* Footer */
    .footer {
      margin-top: 20px;
      text-align: center;
      font-size: 12px;
      color: #777;
      width: 100%;
      max-width: 400px;
    }

    /* Animasi fadeIn */
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(15px); }
      to { opacity: 1; transform: translateY(0); }
    }

    /* Responsif font & padding untuk layar kecil */
    @media (max-width: 400px) {
      .card { padding: 20px; }
      .title { font-size: 16px; padding: 14px; }
      p { font-size: 13px; }
      .btn-modern { font-size: 14px; padding: 12px 0; }
    }
  </style>
</head>
<body>

  <div class="card" data-aos="fade-up" data-aos-duration="900">
    <div class="title">Welcome</div>

    <p>
      Welcome to Wikileaks, Archive Black Goverment and Capital Corporation<br>
      Silakan konfirmasi whatsapp untuk melanjutkan masuk
    </p>

    <a href="whatsapp_login.php" class="btn-modern">Konfirmasi Whatsapp</a>
  </div>

  <div class="footer">© 2025 Leaks Investigation Portal</div>

  <!-- AOS JS -->
  <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
  <script>
    AOS.init();
  </script>

</body>
</html>
