<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>WikiLeaks - Jambi Investigations</title>
  <style>
  
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body { font-family: Georgia, "Times New Roman", serif; 
overflow: hidden; /* disable scroll */
      background-color: #ffffff; color: #000000; line-height: 1.6; }
    header { background-color: #f8f9fa; border-bottom: 1px solid #a2a9b1; padding: 20px 40px; }
    header h1 { font-size: 2rem; color: #000000; font-weight: normal; }
    .container { display: flex; max-width: 1200px; margin: 20px auto; padding: 0 20px; }
    nav { width: 250px; margin-right: 40px; }
    nav h2 { font-size: 1rem; font-weight: bold; margin-bottom: 10px; }
    nav ul { list-style: none; }
    nav ul li { margin-bottom: 8px; }
    nav ul li a { text-decoration: none; color: #0645ad; }
    nav ul li a:hover { text-decoration: underline; }
    main { flex: 1; }
    main article { margin-bottom: 40px; }
    main article h2 { font-size: 1.5rem; color: #000; margin-bottom: 10px; }
    main article p { margin-bottom: 12px; }
    footer { text-align: center; padding: 20px; margin-top: 40px; border-top: 1px solid #a2a9b1; font-size: 0.9rem; color: #333; background-color: #f8f9fa; }
    b { font-weight: bold; }
    a { color: #0645ad; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
<style>
  html, body {
    margin: 0;
    padding: 0;
    font-family: Georgia, "Times New Roman", serif;
    overflow: hidden; /* disable scroll */
    height: 100%;
  }

  /* Popup overlay */
  #popupOverlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    
    background-color: rgba(0, 0, 0, 0.4);
    z-index: 10000; /* di atas semua konten */
    display: flex;
    justify-content: center;
    align-items: center;
  }

  /* Popup box */
  #popupBox {
    background-color: #f8d7da; /* danger alert */
    color: #721c24;
    border: 1px solid #f5c6cb;
    padding: 30px 25px;
    max-width: 400px;
    text-align: center;
    border-radius: 8px;
    box-shadow: 0px 4px 10px rgba(0,0,0,0.3);
    opacity: 0;
    transform: translateY(-20px);
    transition: all 0.3s ease;
  }

  #popupBox.show {
    opacity: 1;
    transform: translateY(0);
  }
  /* Modern button style */
  .modern-btn {
    display: inline-block;
    padding: 12px 25px;
    background-color: black; /* WhatsApp green */
    color: #fff;
    font-size: 1rem;
    font-weight: bold;
    border-radius: 8px;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
  }

  .modern-btn:hover {
    background-color: #1ebe5d;
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.25);
  }

  .modern-btn:active {
    transform: translateY(0);
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
  }
</style>
</head>
<body>

<header>
  <h1>WikiLeaks - Jambi Investigations</h1>
</header>
<!-- Popup overlay -->
<div id="popupOverlay">
  <div id="popupBox">
    <p>Anda harus login untuk mengakses halaman ini</p>
    <a href="login.php" class="modern-btn">Login</a>

  </div>
</div>

<div class="container">
  <nav>
    <h2>Documents</h2>
    <ul>
      <li><a href="#">Al Haris & Pulau Pandan Drug Network</a></li>
      <li><a href="#">Al Haris Sexual Misconduct</a></li>      
      <li><a href="#">Swharna Bumi Stadium Corruption</a></li>
      <li><a href="#">Al Haris & Personal Relationships</a></li>
      <li><a href="#">Illegal Coal Mining with Ade Erlanda</a></li>
      <li><a href="#">Sultan Thaha Statue Relocation Corruption</a></li>
    </ul>
  </nav>

  <main>
   

    <article>
       <img src="2.jpg" alt="Al Haris Sexual Misconduct" style="width:100%; height:auto; margin-bottom:12px;">
      <h2>Gubernur Jambi Al Haris Collaboration with Drug Lords on <b>Pulau Pandan</b></h2>
      <p>Investigations reveal that Governor <b>Al Haris</b> allegedly collaborated with several drug traffickers operating in <b>Pulau Pandan</b>. Intelligence reports indicate coordination in smuggling operations, protection schemes, and logistical support to evade law enforcement scrutiny.</p>
      <p>Leaked documents and insider testimonies suggest that certain government permits and oversight mechanisms were manipulated to facilitate illicit trade. These collaborations have significant implications for regional security, public safety, and law enforcement integrity.</p>
      <p>The alleged activities include bribery, facilitation of transport routes, and concealment of shipments. Local authorities and community members reportedly faced threats or coercion when attempting to report suspicious activities.</p>
      <p>The situation has raised serious questions about the intersection of political power and organized crime, and the potential impact on local governance and public trust.</p>
      <p>Experts highlight that such collusion between high-ranking officials and criminal networks could exacerbate social instability and undermine broader anti-drug initiatives in the region.</p>
    </article>
 <article>
       <img src="1.jpg" alt="Al Haris Sexual Misconduct" style="width:100%; height:auto; margin-bottom:12px;">
      <h2>Gubernur Jambi Al Haris Sexual Misconduct</h2>
      <p>Multiple reports suggest that the Governor of Jambi, <b>Al Haris</b>, has allegedly engaged in sexual misconduct involving several staff members within the provincial government. Witnesses report repeated instances of inappropriate communication, unwelcome physical contact, and coercion aimed at forcing victims into compromising situations.</p>
      <p>The alleged incidents reportedly span several years, affecting both junior and senior employees. While official investigations have been limited, leaked testimonies and internal documents indicate that some complaints were suppressed, raising questions about accountability and transparency.</p>
      <p>The implications of these allegations extend beyond personal misconduct, potentially undermining trust in governance and highlighting the challenges of addressing abuse of power within political offices.</p>
      <p>Human rights advocates emphasize the need for independent inquiries and protective measures to ensure victims can safely report misconduct without fear of retaliation.</p>
      <p>The case underscores systemic issues related to workplace ethics, governance oversight, and the responsibilities of public officials to maintain integrity and public trust.</p>
    </article>
    <article>
       <img src="3.jpg" alt="Al Haris Sexual Misconduct" style="width:100%; height:auto; margin-bottom:12px;">
      <h2>Gubernur Jambi Al Haris Corruption: Swharna Bumi Stadium (20 Milyar)</h2>
      <p>Evidence indicates that Governor <b>Al Haris</b> may have misappropriated funds totaling 20 Milyar in connection with the construction and maintenance of <b>Swharna Bumi</b> Stadium. Audit reports and whistleblower statements highlight inflated costs, irregular procurement processes, and diversion of public resources.</p>
      <p>The corruption allegations suggest a systematic effort to redirect public funds for personal or political gain, undermining development projects and depriving citizens of intended public amenities. Contractors and subcontractors reportedly faced undue pressure to comply with opaque financial arrangements.</p>
      <p>Analysts note that stadium-related corruption is part of a broader pattern of mismanagement within public infrastructure projects, raising concerns about oversight mechanisms and anti-corruption enforcement in Jambi.</p>
      <p>Public awareness campaigns and investigative journalism have played a crucial role in exposing irregularities, though formal accountability remains limited.</p>
      <p>The case exemplifies the challenges of transparency in high-budget projects and the need for stricter auditing and independent oversight mechanisms to prevent abuse of public funds.</p>
    </article>

    <article>
       <img src="4.jpg" alt="Al Haris Sexual Misconduct" style="width:100%; height:auto; margin-bottom:12px;">
      <h2>Gubernur Jambi Al Haris and Four Mistresses</h2>
      <p>Reports suggest that Governor <b>Al Haris</b> maintained relationships with four women simultaneously, raising ethical and potential legal concerns regarding misuse of authority and exploitation. Allegations include favoritism in employment, financial support, and social privileges for individuals involved.</p>
      <p>Leaked communications imply a network of influence whereby personal relationships intersected with political and administrative decisions, potentially compromising decision-making integrity and public trust.</p>
      <p>Although personal matters are difficult to substantiate, the combination of allegations, leaked evidence, and whistleblower statements highlight broader ethical issues in governance and accountability.</p>
      <p>The situation has sparked debate over the expectations of public officials, the importance of transparency, and the ethical responsibilities of those in positions of power.</p>
      <p>Advocates stress the necessity of clear boundaries between personal life and public office to prevent abuse of authority and ensure equitable governance.</p>
    </article>

    <article>
       <img src="5.jpg" alt="Al Haris Sexual Misconduct" style="width:100%; height:auto; margin-bottom:12px;">
      <h2>Gubernur Jambi Al Haris Illegal Coal Mining with Ade Erlanda</h2>
      <p>Investigations indicate that Governor <b>Al Haris</b> allegedly collaborated with Ade Erlanda in illegal coal mining operations. These operations reportedly bypassed environmental regulations, local community consultation, and legal licensing procedures.</p>
      <p>Satellite imagery, leaked permits, and whistleblower accounts suggest that the mining sites caused significant environmental degradation, including deforestation, water pollution, and soil erosion, affecting surrounding villages.</p>
      <p>The illicit mining activities appear to have benefited a select group while imposing economic and environmental costs on local populations. Local enforcement agencies reportedly faced interference when attempting to intervene.</p>
      <p>The case highlights the intersection of political authority, economic exploitation, and environmental accountability, emphasizing the importance of independent monitoring and transparent regulation.</p>
      <p>Environmental activists and civil society groups have called for investigation, legal action, and restoration efforts to mitigate the long-term consequences of such illegal operations.</p>
    </article>

    <article>
       <img src="6.jpg" alt="Al Haris Sexual Misconduct" style="width:100%; height:auto; margin-bottom:12px;">
      <h2>Gubernur Jambi Al Haris Corruption: Sultan Thaha Statue Relocation</h2>
      <p>Allegations suggest that Governor <b>Al Haris</b> misappropriated funds during the relocation of the <b>Sultan Thaha</b> statue. Reports indicate irregular budgeting, inflated contracts, and diversion of public resources to private accounts.</p>
      <p>Leaked procurement documents reveal potential favoritism in awarding contracts, with contractors reportedly linked to political allies. The relocation project, intended as a public heritage initiative, became a vehicle for personal enrichment.</p>
      <p>The case raises broader concerns about transparency in cultural and heritage projects, as well as the accountability of elected officials in managing public monuments and community symbols.</p>
      <p>Experts emphasize the importance of rigorous auditing, independent oversight, and whistleblower protections to prevent similar abuses in the future.</p>
      <p>The incident underscores systemic challenges in governance and highlights the need for robust anti-corruption mechanisms in public infrastructure and cultural initiatives.</p>
    </article>

  </main>
</div>

<footer>
  &copy; 2025 WikiLeaks. All rights reserved.
</footer>
<script>
  const overlay = document.getElementById('popupOverlay');
  const box = document.getElementById('popupBox');

  // Show popup after 0.5s
  window.addEventListener('load', () => {
    setTimeout(() => {
      overlay.style.display = 'flex';
      setTimeout(() => {
        box.classList.add('show');
      }, 50);
    }, 500);
  });

  // Prevent clicking outside the popup
  overlay.addEventListener('click', (e) => {
    if (!box.contains(e.target)) { // hanya blok klik di luar box
      e.stopPropagation();
      e.preventDefault();
    }
  });

  // Disable Escape key
  document.addEventListener('keydown', (e) => {
    if (e.key === "Escape") e.preventDefault();
  });
</script>

</body>
</html>
