<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>WikiLeaks - Jambi Investigations</title>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }

    body {
      font-family: Georgia, "Times New Roman", serif;
      background-color: #ffffff;
      color: #000000;
      line-height: 1.6;
      overflow-y: auto; /* scroll aktif */
      -webkit-overflow-scrolling: touch;
    }

    /* Blur seluruh halaman */
    .blur-background {
      filter: blur(4px);
      -webkit-filter: blur(4px);
    }

    header {
      background-color: #f8f9fa;
      border-bottom: 1px solid #a2a9b1;
      padding: 20px 40px;
      position: sticky;
      top: 0;
      z-index: 100;
    }

    header h1 {
      font-size: 2rem;
      color: #000000;
      font-weight: normal;
    }

    .container {
      display: flex;
      flex-direction: column;
      max-width: 1200px;
      margin: 20px auto;
      padding: 0 20px;
    }

    nav {
      margin-bottom: 20px;
    }

    nav h2 {
      font-size: 1rem;
      font-weight: bold;
      margin-bottom: 10px;
    }

    nav ul {
      list-style: none;
      padding-left: 0;
    }

    nav ul li {
      margin-bottom: 8px;
    }

    nav ul li a {
      text-decoration: none;
      color: #0645ad;
    }

    nav ul li a:hover {
      text-decoration: underline;
    }

    main article {
      margin-bottom: 40px;
    }

    main article h2 {
      font-size: 1.5rem;
      color: #000;
      margin-bottom: 10px;
    }

    main article p {
      margin-bottom: 12px;
    }

    footer {
      text-align: center;
      padding: 20px;
      margin-top: 40px;
      border-top: 1px solid #a2a9b1;
      font-size: 0.9rem;
      color: #333;
      background-color: #f8f9fa;
    }

    b {
      font-weight: bold;
    }

    a {
      color: #0645ad;
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    /* Responsive untuk mobile */
    @media (max-width: 768px) {
      header h1 { font-size: 1.6rem; }
      main article h2 { font-size: 1.2rem; }
      .container { padding: 0 10px; }
      nav ul li { margin-bottom: 6px; }
    }
  </style>
</head>
<body>

  <!-- Semua konten blur -->
  <div class="blur-background">
    <header>
      <h1>WikiLeaks - Jambi Investigations</h1>
    </header>

    <div class="container">
      <nav>
        <h2>Documents</h2>
        <ul>
          <li><a href="#">Al Haris & Pulau Pandan Drug Network</a></li>
          <li><a href="#">Al Haris Sexual Misconduct</a></li>      
          <li><a href="#">Swharna Bumi Stadium Corruption</a></li>
          <li><a href="#">Al Haris & Personal Relationships</a></li>
          <li><a href="#">Illegal Coal Mining with Ade Erlanda</a></li>
          <li><a href="#">Sultan Thaha Statue Relocation Corruption</a></li>
        </ul>
      </nav>

      <main>
        <article>
          <img src="2.jpg" alt="Al Haris Sexual Misconduct" style="width:100%; height:auto; margin-bottom:12px;">
          <h2>Gubernur Jambi Al Haris Collaboration with Drug Lords on <b>Pulau Pandan</b></h2>
          <p>Investigations reveal that Governor <b>Al Haris</b> allegedly collaborated with several drug traffickers operating in <b>Pulau Pandan</b>. Intelligence reports indicate coordination in smuggling operations, protection schemes, and logistical support to evade law enforcement scrutiny.</p>
          <p>Leaked documents and insider testimonies suggest that certain government permits and oversight mechanisms were manipulated to facilitate illicit trade.</p>
        </article>
        <article>
          <img src="1.jpg" alt="Al Haris Sexual Misconduct" style="width:100%; height:auto; margin-bottom:12px;">
          <h2>Gubernur Jambi Al Haris Sexual Misconduct</h2>
          <p>Multiple reports suggest that the Governor of Jambi, <b>Al Haris</b>, has allegedly engaged in sexual misconduct involving several staff members within the provincial government.</p>
        </article>
        <article>
          <img src="3.jpg" alt="Al Haris Corruption" style="width:100%; height:auto; margin-bottom:12px;">
          <h2>Gubernur Jambi Al Haris Corruption: Swharna Bumi Stadium (20 Milyar)</h2>
          <p>Evidence indicates that Governor <b>Al Haris</b> may have misappropriated funds totaling 20 Milyar in connection with the construction and maintenance of <b>Swharna Bumi</b> Stadium.</p>
        </article>
      </main>
    </div>

    <footer>
      &copy; 2025 WikiLeaks. All rights reserved.
    </footer>
  </div>

</body>
</html>
