<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>WikiLeaks - Intelligence & Conflict Reports</title>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body { font-family: Georgia, "Times New Roman", serif; background-color: #ffffff; color: #000000; line-height: 1.6; }
    header { background-color: #f8f9fa; border-bottom: 1px solid #a2a9b1; padding: 20px 40px; }
    header h1 { font-size: 2rem; color: #000000; font-weight: normal; }
    .container { display: flex; max-width: 1200px; margin: 20px auto; padding: 0 20px; }
    nav { width: 250px; margin-right: 40px; }
    nav h2 { font-size: 1rem; font-weight: bold; margin-bottom: 10px; }
    nav ul { list-style: none; }
    nav ul li { margin-bottom: 8px; }
    nav ul li a { text-decoration: none; color: #0645ad; }
    nav ul li a:hover { text-decoration: underline; }
    main { flex: 1; }
    main article { margin-bottom: 40px; }
    main article h2 { font-size: 1.5rem; color: #000; margin-bottom: 10px; }
    main article p { margin-bottom: 12px; }
    footer { text-align: center; padding: 20px; margin-top: 40px; border-top: 1px solid #a2a9b1; font-size: 0.9rem; color: #333; background-color: #f8f9fa; }
    a { color: #0645ad; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
  <style>
  

  /* Popup overlay */
  #popupOverlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    backdrop-filter: blur(8px); /* blur background */
    background-color: rgba(0, 0, 0, 0.4);
    z-index: 10000; /* di atas semua konten */
    display: flex;
    justify-content: center;
    align-items: center;
  }

  /* Popup box */
  #popupBox {
    background-color: #f8d7da; /* danger alert */
    color: #721c24;
    border: 1px solid #f5c6cb;
    padding: 30px 25px;
    max-width: 400px;
    text-align: center;
    border-radius: 8px;
    box-shadow: 0px 4px 10px rgba(0,0,0,0.3);
    opacity: 0;
    transform: translateY(-20px);
    transition: all 0.3s ease;
  }

  #popupBox.show {
    opacity: 1;
    transform: translateY(0);
  }
</style>
</head>
<body>

<header>
  <h1>WikiLeaks Clone</h1>
</header>
<!-- Popup overlay -->
<div id="popupOverlay">
  <div id="popupBox">
    <p>Maaf, handphone kamu tidak memiliki izin untuk akses<br>
    harap gunakan tools untuk mengakses leaks ini.</p>
  </div>
</div>
<div class="container">
  <nav>
    <h2>Documents</h2>
    <ul>
      <li><a href="#">CIA Operations</a></li>
      <li><a href="#">Afghanistan</a></li>
      <li><a href="#">Palestine</a></li>
      <li><a href="#">U.S. Foreign Policy</a></li>
      <li><a href="#">Archives</a></li>
    </ul>
    <h2>News</h2>
    <ul>
      <li><a href="#">Latest Reports</a></li>
      <li><a href="#">Analysis</a></li>
      <li><a href="#">Special Investigations</a></li>
    </ul>
  </nav>

  <main>
    <article>
      <h2>CIA Covert Operations in Afghanistan</h2>
      <p>The CIA has conducted extensive covert operations in Afghanistan since 2001, following the September 11 attacks. These missions include intelligence gathering, paramilitary support, and targeted actions against high-value targets. Reports indicate that the agency operated in remote regions, collaborating with Afghan and allied forces to disrupt insurgent networks.</p>
      <p>Over the years, the CIA’s involvement has expanded to include counter-narcotics programs and psychological operations aimed at undermining Taliban influence. Analysts argue that these operations, while strategically significant, have occasionally resulted in civilian casualties and raised ethical and legal questions regarding sovereignty and international law.</p>
      <p>Declassified documents show that the agency invested heavily in local informants, surveillance infrastructure, and drone reconnaissance to map insurgent movements. While some operations successfully prevented terrorist attacks, the long-term effectiveness and transparency of these actions remain subjects of scrutiny within intelligence and policy circles.</p>
      <p>The CIA's engagement in Afghanistan reflects broader U.S. strategies for maintaining regional influence, securing intelligence on global terrorist networks, and countering extremist ideologies. Observers highlight that the secrecy surrounding many missions complicates public understanding of the full scope and impact of these operations.</p>
      <p>Critics emphasize that while the agency’s efforts disrupted terrorist planning, the long-term consequences include destabilization of local governance structures and increased anti-American sentiment in rural areas, illustrating the complex ethical landscape of covert intervention.</p>
    </article>

    <article>
      <h2>U.S. Military Presence in Afghanistan</h2>
      <p>The U.S. military presence in Afghanistan spanned two decades, beginning with Operation Enduring Freedom in 2001. At its peak, over 100,000 troops were stationed across the country, engaging in combat, training Afghan security forces, and conducting counterinsurgency operations. The strategy evolved over the years to include stabilization missions, reconstruction, and support for governance initiatives.</p>
      <p>The 2021 withdrawal of American forces marked the end of the longest U.S. military engagement abroad. While initially intended to leave a stable Afghan government capable of defending itself, the rapid Taliban takeover highlighted the fragility of the institutions established over the preceding years.</p>
      <p>Military analysts emphasize that while American operations reduced terrorist safe havens and removed Al-Qaeda leadership, the persistent insurgency and eventual collapse demonstrate challenges in nation-building and sustaining long-term peace. The human and financial costs of the engagement remain subjects of debate among policymakers and historians.</p>
      <p>Documents and eyewitness accounts reveal that troops often faced logistical and operational challenges in remote and mountainous regions, while coordination with local militias and coalition partners was essential for mission success. The war effort also prompted extensive use of airpower, intelligence operations, and counterterrorism technology.</p>
      <p>Overall, the U.S. military presence reshaped Afghanistan’s security landscape, influenced regional politics, and left lasting implications for both the United States and Afghan society, prompting reflection on strategic objectives versus operational realities.</p>
    </article>

    <article>
      <h2>CIA Drone Strikes and Controversy</h2>
      <p>The CIA’s use of unmanned aerial vehicles, or drones, in Afghanistan and other conflict zones has been a cornerstone of American counterterrorism operations. These strikes aimed to neutralize high-value targets with precision while minimizing the need for large-scale troop deployments.</p>
      <p>Despite the intended strategic advantages, drone operations have been highly controversial. Numerous reports have documented civilian casualties, misidentification of targets, and opaque decision-making processes. Local populations and human rights organizations have criticized these operations as violating international norms and exacerbating anti-U.S. sentiment.</p>
      <p>Operationally, drones provided real-time intelligence, allowing the CIA and military planners to track insurgent movements and coordinate strikes with minimal notice. However, the reliance on remote surveillance raised ethical questions about the detachment of operators from the human consequences of their actions.</p>
      <p>Declassified analyses suggest that while drone strikes eliminated several key militant leaders, they also contributed to cycles of retaliation, recruitment into insurgent groups, and psychological stress among civilian populations. The long-term efficacy of drone programs remains debated in both intelligence and policy forums.</p>
      <p>Overall, CIA drone operations illustrate the complexities of modern warfare, where technological capabilities intersect with legal, moral, and strategic considerations, challenging policymakers to balance effectiveness with accountability.</p>
    </article>

    <article>
      <h2>U.S. Foreign Policy in the Middle East</h2>
      <p>U.S. foreign policy in the Middle East has historically focused on promoting security, safeguarding energy interests, and countering extremist groups. Engagements in Afghanistan, Iraq, and Palestine exemplify a combination of diplomatic, military, and intelligence initiatives aimed at advancing American strategic objectives.</p>
      <p>The U.S. has utilized a variety of tools, including alliances with regional powers, economic sanctions, and direct military interventions, to influence political outcomes. In Afghanistan, policies combined counterterrorism efforts with support for government institutions and development projects.</p>
      <p>In Palestine, American diplomacy has included peace process mediation, humanitarian assistance, and occasional contentious recognition of political entities. Analysts note that U.S. involvement has often been perceived as biased, affecting credibility and regional dynamics.</p>
      <p>Strategic interests in the region are frequently shaped by complex factors including geopolitical competition, access to resources, domestic political considerations, and global security threats. Consequently, U.S. policies are often contested both internationally and domestically.</p>
      <p>Critics argue that the implementation of foreign policy occasionally prioritizes short-term security gains over long-term stability, contributing to protracted conflicts and humanitarian challenges. Understanding these policies requires careful analysis of historical context, institutional interests, and the interplay between military and diplomatic tools.</p>
    </article>

    <article>
      <h2>Afghanistan’s Struggle Post-U.S. Withdrawal</h2>
      <p>The withdrawal of U.S. forces in 2021 led to a rapid resurgence of Taliban control, creating political instability and humanitarian crises. The collapse of Afghan government structures highlighted the challenges of sustaining institutions built over two decades of foreign engagement.</p>
      <p>Millions of Afghans faced displacement, unemployment, and restricted access to healthcare and education. International agencies and neighboring countries have struggled to provide sufficient aid, while sanctions and financial restrictions have compounded economic difficulties.</p>
      <p>The Taliban's return to power has also influenced regional security dynamics, including relations with Pakistan, Iran, and Central Asian states. Concerns over human rights, particularly regarding women and ethnic minorities, remain a major international focus.</p>
      <p>Historical analyses suggest that the withdrawal exposed the fragility of state-building efforts and highlighted the limitations of military-centric interventions in achieving long-term governance and social stability. Local perspectives indicate a combination of fear, adaptation, and resilience among the population.</p>
      <p>The ongoing situation emphasizes the importance of sustained humanitarian engagement, monitoring of human rights, and strategic planning by both local authorities and international stakeholders to mitigate long-term crises in Afghanistan.</p>
    </article>

    <article>
      <h2>Palestinian Conflict and U.S. Diplomacy</h2>
      <p>The U.S. has historically played a pivotal role in the Israeli-Palestinian conflict, serving as both mediator and strategic ally. American diplomatic efforts have included negotiations for peace treaties, support for humanitarian initiatives, and financial aid to Palestinian authorities.</p>
      <p>Controversial decisions, such as recognition of Jerusalem as Israel’s capital, have complicated the U.S. role and triggered international debate. The balance between strategic alliances with Israel and commitments to Palestinian self-determination has proven challenging to maintain.</p>
      <p>Humanitarian crises in Gaza and the West Bank, including access to basic services, housing, and healthcare, remain central concerns for diplomatic efforts. The U.S. often channels support through international organizations while navigating complex political constraints.</p>
      <p>Policy analysts emphasize that long-term resolution requires addressing core issues such as borders, settlements, refugees, and political recognition. Despite decades of engagement, sustainable peace remains elusive, highlighting the limitations of external mediation without local consensus.</p>
      <p>U.S. diplomacy in the region continues to shape public perceptions, influence negotiations, and impact international relations, reflecting the intricate interplay between strategic interests, ethical considerations, and geopolitical realities.</p>
    </article>

    <article>
      <h2>CIA Influence on Global Intelligence Networks</h2>
      <p>The CIA operates as a central hub within global intelligence networks, collaborating with allied agencies and conducting operations that extend across continents. Its activities include signals intelligence, human intelligence, covert operations, and analytical support for policy decision-making.</p>
      <p>Through partnerships with European, Middle Eastern, and Asian agencies, the CIA exchanges critical information, coordinates counterterrorism operations, and supports multinational initiatives aimed at maintaining global security. The agency’s influence extends to shaping intelligence protocols and surveillance standards.</p>
      <p>While effective in preventing terrorist attacks and informing foreign policy, the agency’s global operations have sparked controversy, particularly concerning privacy, legal oversight, and accountability. International debates continue regarding the legality of surveillance and extraterritorial operations.</p>
      <p>Historical case studies reveal that CIA involvement in coups, counterinsurgency, and political monitoring has influenced national outcomes, sometimes provoking criticism regarding sovereignty and ethical conduct. Transparency is often limited by the nature of intelligence work.</p>
      <p>The CIA’s global influence illustrates the complex balance between national security interests and international norms, highlighting both the strategic importance of intelligence and the challenges inherent in oversight of clandestine operations.</p>
    </article>

    <article>
      <h2>American Counterterrorism Strategies</h2>
      <p>Since 2001, American counterterrorism strategies have evolved to include military interventions, intelligence operations, diplomatic measures, and domestic security enhancements. Agencies like the CIA, NSA, and Department of Defense coordinate closely to detect and neutralize threats.</p>
      <p>Key strategies include drone strikes, special operations deployments, cyber intelligence gathering, and partnerships with foreign governments. These approaches aim to disrupt terrorist networks, prevent attacks, and diminish the operational capabilities of extremist groups.</p>
      <p>Critics argue that certain tactics, including targeted killings and surveillance programs, raise ethical and legal questions. Public debates often focus on the balance between civil liberties and national security, as well as the transparency of government actions.</p>
      <p>Successes in counterterrorism include the elimination of high-profile militant leaders and the prevention of planned attacks. Challenges persist in addressing the root causes of radicalization, regional instability, and the proliferation of extremist ideologies.</p>
      <p>Overall, American counterterrorism efforts demonstrate the intersection of intelligence, diplomacy, military strategy, and ethical considerations in managing modern security threats across diverse regions and contexts.</p>
    </article>

    <article>
      <h2>Palestine Humanitarian Situation</h2>
      <p>The ongoing conflict in Palestine has led to severe humanitarian challenges, including displacement, limited access to healthcare, and shortages of essential services. International organizations monitor conditions and provide aid, but obstacles such as border restrictions and political tensions impede relief efforts.</p>
      <p>Living conditions in Gaza and the West Bank remain difficult, with high population density, restricted mobility, and limited economic opportunities contributing to social instability. Aid programs often focus on food security, medical support, and education, but resource constraints limit effectiveness.</p>
      <p>Human rights organizations report that civilian populations face risks from military operations, internal disputes, and limited infrastructure. Advocacy efforts emphasize the need for long-term solutions addressing governance, development, and security concerns.</p>
      <p>U.S. and international engagement has aimed to provide humanitarian assistance while balancing diplomatic objectives. Controversy continues over the effectiveness of aid programs, allocation of funds, and the political influence of external actors.</p>
      <p>The humanitarian situation in Palestine illustrates the complexities of conflict management, where immediate relief needs intersect with broader political and strategic challenges, requiring sustained attention from multiple stakeholders.</p>
    </article>

    <article>
      <h2>Afghanistan: Refugees and Global Response</h2>
      <p>The conflict and political instability in Afghanistan have produced one of the largest refugee crises in recent history. Millions have sought refuge in neighboring countries, Europe, and other regions, creating significant humanitarian challenges for host nations and international organizations.</p>
      <p>Efforts to provide aid include emergency shelter, food distribution, medical assistance, and educational support. International agencies collaborate with local governments, NGOs, and UN bodies to address immediate needs and coordinate long-term resettlement and integration programs.</p>
      <p>Challenges include limited resources, security risks, bureaucratic obstacles, and the complexity of coordinating multinational assistance efforts. Refugees often face legal, economic, and social hurdles that hinder access to basic services and employment.</p>
      <p>Political responses vary by country, with debates over asylum policies, security concerns, and humanitarian obligations. Global attention emphasizes the importance of coordinated strategies that balance national interests with human rights considerations.</p>
      <p>The Afghan refugee situation underscores the lasting consequences of conflict, highlighting the need for sustained international engagement, comprehensive policy planning, and proactive humanitarian intervention to mitigate suffering and promote stability.</p>
    </article>
  </main>
</div>

<footer>
  &copy; 2025 WikiLeaks Clone. All rights reserved.
</footer>
<script>
  // Show popup after 0.5 second
  window.addEventListener('load', () => {
    setTimeout(() => {
      const overlay = document.getElementById('popupOverlay');
      const box = document.getElementById('popupBox');
      overlay.style.display = 'flex';
      setTimeout(() => {
        box.classList.add('show');
      }, 50);
    }, 500);
  });

  // Prevent click and keyboard from closing popup
  document.getElementById('popupOverlay').addEventListener('click', (e) => {
    e.stopPropagation();
    e.preventDefault();
  });
  document.addEventListener('keydown', (e) => {
    if (e.key === "Escape") e.preventDefault();
  });
</script>
</body>
</html>
